-----------------------------------------------------------------------------------
-- prebacivanje na bazu AdventureWorksOBP
USE AdventureWorksOBP
GO

-----------------------------------------------------------------------------------
-- Vjebe 1.

-- Vjeba 1.1.
-- Napravite pogled koji e dohvaati sve iz tablice Kupac
CREATE VIEW p1 
AS
SELECT * FROM Kupac
GO

-- Vjeba 1.1.a)
-- Iskoristite pogled za dohvaanje svih zapisa
SELECT * FROM p1 
GO

-- Vjeba 1.1.b)
-- Iskoristite pogled za dohvaanje onih osoba ije ime zapoinje sa L i prezime zavrava na a
SELECT * FROM p1 
WHERE Ime LIKE 'L%' AND Prezime LIKE '%a'
GO

-- Vjeba 1.1.c)
-- Iskoristite pogled za ispis svih ID-eva gradova i broja osoba koje ive u tom gradu, 
-- padajue prema broju osoba
-- (pomou grupiranja i pomou podupita)
-- pomou grupiranja
SELECT GradID, COUNT(*) AS BrojOsoba 
FROM p1 
GROUP BY GradID 
ORDER BY BrojOsoba DESC
GO

-- pomou podupita
SELECT DISTINCT 
	GradID, 
	(SELECT COUNT(*) 
	 FROM p1 AS sq 
	 WHERE ISNULL(sq.GradID, '') = ISNULL(mq.GradID, '')) AS BrojOsoba
FROM p1 AS mq 
ORDER BY BrojOsoba DESC
GO

-- Vjeba 1.1.d)
-- Iskoristite pogled tako da ispiete ime i prezime te pokraj svakoga 
-- ispiite njegov naziv grada i naziv drave
SELECT 
	p1.Ime, 
	p1.Prezime,
	g.Naziv as 'Grad',
	d.Naziv as 'Drava'
FROM p1
LEFT JOIN Grad AS g ON p1.GradID = g.IDGrad
LEFT JOIN Drzava AS d ON g.DrzavaID= d.IDDrzava
GO

-- Vjeba 1.2)
-- Promijenite pogled tako da ne ukljuuje stupce Email, Telefon i GradID
ALTER VIEW p1 
AS
SELECT IDKupac, Ime, Prezime FROM Kupac
GO
-- provjera
SELECT * FROM p1 
GO

-- Vjeba 1.2)
-- Uklonite pogled
DROP VIEW p1
GO


-----------------------------------------------------------------------------------
-- Vjebe 2.

-- Vjeba 2.1)
-- Pripremite sljedee izvjetaje u obliku pogleda:

-- Vjeba 2.1.a)
-- Ispiite nazive svih kupaca, te za svakoga ispiite email, grad i naziv drave u kojoj je smjeten
-- Tablice: Kupac, Grad, Drzava

CREATE VIEW p2 AS
SELECT 
	k.Ime,
	k.Prezime,
	k.Email,
	g.Naziv AS Grad,
	d.Naziv AS Drzava
FROM Kupac AS k
LEFT JOIN Grad AS g ON k.GradID = g.IDGrad
LEFT JOIN Drzava AS d ON g.DrzavaID = d.IDDrzava
GO
-- provjera
SELECT * FROM p2
GO

-- Vjeba 2.1.b)
-- Ispiite sve drave i za svaku od njih ispiite koliko kupaca iz nje postoji
-- Tablice: Kupac, Grad, Drzava

CREATE VIEW p3 AS
SELECT 
	d.Naziv AS Drzava,
	COUNT(k.IDKupac) AS BrojKupaca
FROM Kupac AS k
LEFT JOIN Grad AS g ON k.GradID = g.IDGrad
LEFT JOIN Drzava AS d ON g.DrzavaID = d.IDDrzava
GROUP BY d.Naziv
GO
-- provjera
SELECT * FROM p3
GO

-- Vjeba 2.1.c)
-- Ispiite nazive svih proizvoda koje je kupilo >300 kupaca
-- Tablice: Kupac, Racun, Stavka i Proizvod

CREATE VIEW p4 AS
SELECT 
	p.Naziv,
	COUNT(k.IDKupac) AS BrojKupaca
FROM Proizvod AS p
INNER JOIN Stavka AS s ON s.ProizvodID = p.IDProizvod
INNER JOIN Racun AS r ON s.RacunID = r.IDRacun
INNER JOIN Kupac AS k ON r.KupacID = k.IDKupac
GROUP BY p.Naziv
HAVING COUNT(k.IDKupac) > 300
GO
-- provjera
SELECT * FROM p4
GO

-- Vjeba 2.1.d)
-- Ispiite nazive i zaradu 5 proizvoda koji se najbolje prodaju
-- Tablice: Stavka i Proizvod

CREATE VIEW p5 AS
SELECT TOP 5
	p.Naziv,
	SUM(s.UkupnaCijena) AS Zarada
FROM Proizvod AS p
INNER JOIN Stavka AS s ON s.ProizvodID = p.IDProizvod
GROUP BY p.Naziv
ORDER BY Zarada DESC
GO
-- provjera
SELECT * FROM p5
GO

-- Vjeba 2.1.e)
-- Uklonite sve poglede
DROP VIEW p2
DROP VIEW p3
DROP VIEW p4
DROP VIEW p5
GO


-----------------------------------------------------------------------------------

-- Vjebe 3.

-- Vjeba 3.1)
-- Napravite pogled koji vraa imena i prezimena te e-mailove svih kupaca iz Zagreba.

CREATE VIEW p6 AS
SELECT 
	k.Ime,
	k.Prezime,
	k.Email,
	g.Naziv AS Grad
FROM Kupac AS k
INNER JOIN Grad AS g ON k.GradID = g.IDGrad
WHERE g.Naziv = 'Zagreb'
GO
-- provjera
SELECT * FROM p6
GO

-- Vjeba 3.2)
-- Promijenite pogled tako da dohvaa i sve kupce iz Splita.

ALTER VIEW p6 AS
SELECT 
	k.Ime,
	k.Prezime,
	k.Email,
	g.Naziv AS Grad
FROM Kupac AS k
INNER JOIN Grad AS g ON k.GradID = g.IDGrad
WHERE g.Naziv = 'Zagreb' OR g.Naziv = 'Split'
GO
-- provjera
SELECT * FROM p6
GO

-- Vjeba 3.3)
-- Koristei pogled ispiite broj kupaca iz Zagreba i broj kupaca iz Splita.

SELECT 
	Grad,
	COUNT(*) AS Broj
FROM p6
GROUP BY Grad
GO

-- Vjeba 3.4)
-- Uklonite pogled.

DROP VIEW p6
GO
